#include <stdio.h>
#include <stdlib.h> /* calloc() */
#include <string.h> /* strdup() */

#include "debug.h"
#include "do_loop.h"

    /* The do_loop structures aren't _quite_ doubly-linked lists */
    /* I should probably make them so just to ease confusion */
    /* They are actually more like stacks */

struct do_loop_type *push_do_loop(struct do_loop_root *do_loop_info,
				  int line_number) {
  
    struct do_loop_type *temp_do_loop;
   
	     
    if (do_loop_info->head==NULL) {
       do_loop_info->head=calloc(1,sizeof(struct do_loop_type));
       do_loop_info->head->prev=NULL;
       do_loop_info->head->next=NULL;
       do_loop_info->head->line_number=line_number;
       do_loop_info->tail=do_loop_info->head;
       return do_loop_info->head;
    }
    else {
       temp_do_loop=do_loop_info->head;
   	
       while(temp_do_loop->next!=NULL) {
          temp_do_loop=temp_do_loop->next;
       }
       
       temp_do_loop->next=calloc(1,sizeof(struct do_loop_type));       
       /* error check? */
       temp_do_loop->next->line_number=line_number;
       do_loop_info->tail=temp_do_loop->next; 
       temp_do_loop->next->prev=temp_do_loop;     
       temp_do_loop->next->next=NULL;
    }
   
    DEBUG(stderr,"PUSH: %p %p\n",temp_do_loop,do_loop_info->head);
   
    return temp_do_loop->next;
       
}


void pop_do_loop(struct do_loop_root *do_loop_info) {
   
    struct do_loop_type *temp_do_loop;
   
   
    temp_do_loop=do_loop_info->tail;
    
    if (temp_do_loop==NULL) {
       fprintf(stderr,"BIG ERROR\n");
       return;
    }
   
    if (do_loop_info->tail==do_loop_info->head) {
       do_loop_info->head=NULL;
       do_loop_info->tail=NULL;
    }
    else {
       do_loop_info->tail->prev->next=NULL;
       do_loop_info->tail=do_loop_info->tail->prev;
    }
   
   
    free(temp_do_loop->first_line);
    free(temp_do_loop);
    temp_do_loop=NULL;   
   
}

int do_loops_ending(struct do_loop_root *do_loop_info,
			     int line_number,FILE *fout) {
          
    struct do_loop_type *temp_do_loop;
    int loops_ended=0;
   
    if (do_loop_info->count) {
          /* Work backwards... */
       temp_do_loop=do_loop_info->tail;
       while (temp_do_loop!=NULL) {
 			  
             /* We've ended.  Close it up */
	  if (line_number==temp_do_loop->label_end) {
	     loops_ended++;
	   
	  }
	  temp_do_loop=temp_do_loop->prev;
       
       }
    }
    return loops_ended;
}



int end_appropriate_do_loops(struct do_loop_root *do_loop_info,
			     int line_number,FILE *fout) {
          
    struct do_loop_type *temp_do_loop;
    int loops_ended=0;

    DEBUG(stderr,"ENDING %i\n",do_loop_info->count);
    if (do_loop_info->count) {
          /* Work backwards... */
       temp_do_loop=do_loop_info->tail;
       while (temp_do_loop!=NULL) {
 			  
             /* We've ended.  Close it up */
	  if (line_number==temp_do_loop->label_end) {
	     loops_ended++;

	     fprintf(fout,"\n\tlabel=\"%s\";\n",temp_do_loop->first_line);
	     fprintf(fout,"}\n\n");
	     temp_do_loop=temp_do_loop->prev;
	     pop_do_loop(do_loop_info);
	     do_loop_info->count--;
	  }
	     /* We work backwards because it's a stack */
	  else temp_do_loop=temp_do_loop->prev;
       }
       
    }
    return loops_ended;
}


int add_do_loop(struct do_loop_root *do_loop_info,int line_number,
		char *string,int label_end,FILE *fout) {
    
    struct do_loop_type *new_do_loop;
   
       /* Create a new do_loop */
    new_do_loop=push_do_loop(do_loop_info,line_number);
    fprintf(fout,"\nsubgraph cluster%i {\n",line_number);
    do_loop_info->count++;
                
    new_do_loop->label_count=0;
    new_do_loop->first_line=strdup(string);
    new_do_loop->label_end=label_end;
   
    return 0;
   
   
}

