#include <stdio.h>
#include <stdlib.h> /* exit() */
#include <string.h> /* strncpy */
#include <unistd.h> /* getopt */

#include "debug.h"
#include "do_loop.h"
#include "block.h"
#include "label.h"
#include "parse_fortran.h"
#include "links.h"
#include "if.h"

int line_number=0;


struct do_loop_type *do_loop_head=NULL,*do_loop_tail=NULL;


void handle_goto(FILE *fout,struct block_type *current_block,struct link_root_type *link_info,
		 char *string,int *current_label, int if_then) {
   
    int i=0,temp_label,goto_target;
    char goto_gunk[BUFSIZ],label_string[BUFSIZ],*pointer;
   
       /* Seek to end of TO */
    while (!((string[i]=='T') && (string[i+1]=='O') )) {
       i++;
    }
    i+=2;

    strncpy(goto_gunk,string+i,BUFSIZ);

       /* handle ON_GOTO case */
    if (strstr(goto_gunk,"(")) {
       for(i=0;i<strlen(goto_gunk);i++) {
	  if (goto_gunk[i]=='(') goto_gunk[i]=' ';
	  if (goto_gunk[i]==',') goto_gunk[i]=' ';
	  if (goto_gunk[i]==')') goto_gunk[i]='\0';
       }
	    
       i=0;
	    
       pointer=goto_gunk;
       while(*pointer==' ') pointer++; 
	    
       DEBUG(stderr,"ON GOTO: %s\n",goto_gunk);
       add_block_line(current_block,line_number,"ON GOTO");
       
       while((pointer!=NULL) && (sscanf(pointer,"%i",&temp_label))) {
          i++;

	  sprintf(label_string,"on goto %i",i);
	  add_link(link_info,*current_label,0,
			 line_from_label(temp_label),0,label_string,"ON GOTO");
	       
	  strsep(&pointer," ");
       }
       *current_label=-1;
    }
       /* Normal GOTO */	 
    else {
       sscanf(goto_gunk,"%i",&goto_target);
       if (if_then) sprintf(label_string,"THEN GOTO");
       else sprintf(label_string,"GOTO");
       add_link(link_info,*current_label,0,
		      line_from_label(goto_target),0,label_string,"GOTO");
		      
       DEBUG(stderr,"GOTO: %i -> %i\n",*current_label,goto_target);
       if (!if_then) *current_label=-1;
    }	 
    DEBUG(stderr,"GOTO @ %i : %s\n",*current_label,goto_gunk);  
}

#define VERSION "0.0.2"

void help_message(char *executable,int show_help) {
   printf("\n%s version %s\n",executable,VERSION);
   printf("\tby Vince Weaver <vince@deater.net>\n\n");
   if (show_help) {
      printf("Usage:\n");
      printf("\t%s [-o outputfile] [-v] [-h] [-l] [-p] [-r] [-w] inputfile\n\n",executable);
      printf("\t-h\t: This help\n");
      printf("\t-l\t: Fit to letter size (8.5\" x 11\" page\n");
      printf("\t-o file\t: Name of Output File\n");
      printf("\t-p\t: Make 38\" x 50\" the biggest Acrobat for Linux supports\n");
      printf("\t-r\t: Disable display of READ instructions\n");
      printf("\t-v\t: Show version info\n");
      printf("\t-w\t: Disable display of WRITE instructions\n");
      printf("\n");
   }
}

#define LABEL_BLOCK_ENDED -1
#define LABEL_START_NEW_BLOCK -2
#define LABEL_START_NEW_NO_FALLTHROUGH -3

int main(int argc, char **argv) {
 
   FILE *fin=NULL,*fout=NULL;

   char file_name[BUFSIZ];
   char output_file[BUFSIZ];
   
   char temp_string[BUFSIZ],local_string[BUFSIZ],if_gunk[BUFSIZ],
        temp_line_label[BUFSIZ];
   char token[BUFSIZ],if_token[BUFSIZ];
   char do_gunk[BUFSIZ],*gunk=NULL;
   
   int current_label=0,end_do_loops=0;
   
   int i=0,label,temp_label;

   struct if_root if_info = {.head=NULL, .count=0, .else_ifs=0};
      
   char *pointer,*temp_pointer;

   int if_neg,if_zero,if_pos,c;

   int print_reads=1,print_writes=1,letter_paper=0,pdf_size=0,
       early_end=0,outfile_specified=0;
   
   struct do_loop_root do_loop_info = {.count=0};
   int previous_block=0;
   struct block_type current_block;

   struct link_root_type link_info;
   
   
   
       /* Parse Command Line Arguments */
    while ((c = getopt (argc, argv,"hlo:prvw"))!=-1) {
       switch(c) {
          case 'h': help_message(argv[0],1);
                    exit(1);
                    break;
	  case 'l': letter_paper=1;
	            break;
	  case 'o': strncpy(output_file,optarg,BUFSIZ);
	            outfile_specified=1;
	            break;
	  case 'p': pdf_size=1;
	            break;
	  case 'r': print_reads=0;
	            break;
	  case 'w': print_writes=0;
	            break;
	  case 'v': help_message(argv[0],0);
	            exit(1);
	            break;
       }
    }
   
       /* Open the Input and Output Files */
    if (optind==argc) {
       fin=stdin;
    }
    else {
       strncpy(file_name,argv[optind],BUFSIZ);
       fin=fopen(file_name,"r");
       if (fin==NULL) {
          fprintf(stderr,"Could not open file \"%s\"!\n",file_name);
         goto done_and_close;
       }
    }
   
   
   if (!outfile_specified) {
      fout=stdout;
   }
   else {
      fout=fopen(output_file,"w");
      if (fout==NULL) {
          fprintf(stderr,"Could not open file \"%s\" for output!\n",output_file);
          goto done_and_close;
      }
   }

      /***********************\
      | PASS ONE: FIND LABELS |
      \***********************/
   
    DEBUG(stderr,"FIRST PASS\n\n");  
    while(get_fortran_line(fin,temp_string,&line_number,BUFSIZ)!=-1) {
       if (parse_fortran_line(temp_string,&label,token,&gunk)>=0) {
	  DEBUG(stderr,"%i :: %i :: %s :: %s\n",line_number,label,token,gunk);
	  if (label>=0) {
	     add_label(label,line_number);
	  }
       }
    }
    rewind(fin);
    line_number=0;
   
       /***************************\
       | PASS TWO: EVERYTHING ELSE |
       \***************************/
   
    DEBUG(stderr,"SECOND PASS\n\n");

    fprintf(fout,"digraph \"%s\" {\n",file_name);
   
    if (letter_paper) fprintf(fout,"\tsize=\"7.5,10\";\n");
    if (pdf_size) fprintf(fout,"\tsize=\"38.0,50\";\n");
   
     /* Options not yet supported */
/*   fprintf(fout,"\tcompound=true;\n\n");
    fprintf(fout,"\tconcentrate=true;\n");   
    fprintf(fout,"\tpage=\"8.5.11\";\n"); */

    fprintf(fout,"\n");

       /* Start the first block */
    start_block(&current_block,line_number);   
   
       /************************\
       | MAIN LOOP              |
       |                        |
       | Loop Till End of File  |
       \************************/
   
    while( (get_fortran_line(fin,temp_string,&line_number,BUFSIZ)!=-1) &&
           (!early_end)) {
       

       /*fflush(fout);*/
       
          /* Parse the line */
       parse_fortran_line(temp_string,&label,token,&gunk);

       remove_double_quotes(gunk);
       
          /* End any do loops that had to include the last line */
       if (end_do_loops) {
	  previous_block=end_block(&current_block,fout);
          end_appropriate_do_loops(&do_loop_info,end_do_loops,fout);

	  current_label=LABEL_START_NEW_BLOCK;
	  end_do_loops=0;
       }

       
          /* If we have a new label, handle it! */
       if (label>=0) {
	     /* skip format labels.  We _shouldn't_ jump to these */
	  if (!strncmp(token,"FORMAT",6)) {
	     DEBUG(stderr,"FORMAT SKIPPED\n");
	     continue;
	  }

	     /* END old block if we need to */
	  if (current_label>=0) {
	     previous_block=end_block(&current_block,fout);
	  }

	  if ((current_label!=LABEL_BLOCK_ENDED) && (current_label!=LABEL_START_NEW_NO_FALLTHROUGH)) {
	        /* Pass through from old block to new block */
	     add_link(&link_info,previous_block,0,line_number,0,NULL,NULL);
	  }
	  
	      /* Start drawing the next DOT record */
	  start_block(&current_block,line_number);
	    
	  sprintf(temp_line_label,"%i",label_from_line(line_number));
	  add_block_line(&current_block,line_number,temp_line_label);
	  	     
	  current_label=line_number;
       }
          /* No new Label */
       else {
	     /* A block ended in the middle, we want to start a
	      * non-jumpable one */
	  if (current_label==LABEL_START_NEW_BLOCK) {
	     start_block(&current_block,line_number);
	     current_label=line_number;
	     add_link(&link_info,previous_block,0,
		      line_number,0,NULL,NULL);
	  }
	     /* Start a block w/o connecting to previous */
	  if (current_label==LABEL_START_NEW_NO_FALLTHROUGH) {
	     start_block(&current_block,line_number);
	     current_label=line_number;
	  }
       }

       
          /* Check to see if any of the current do_loops have ended */	  
          /* If so, terminate the sub-cluster */
       if (do_loops_ending(&do_loop_info,line_number,fout)) {

	  end_do_loops=line_number;
          fflush(fout);
       }
       
          /***********************\
	  | Handle DO token       |
	  \***********************/
       
       if (!strncmp(token,"DO",sizeof(token))) {
	  previous_block=end_block(&current_block,fout);
	  current_label=LABEL_START_NEW_BLOCK;
	  	  
	     /* Create a new do_loop */
	  strncpy(do_gunk,gunk+2,BUFSIZ);
	  sscanf(do_gunk,"%i",&temp_label);
	  
	  add_do_loop(&do_loop_info,line_number,gunk,
		      line_from_label(temp_label),fout);

	  DEBUG(stderr,"DO FOUND %i -> %i\n",current_label,
		line_from_label(temp_label)); 
	  	  
       }

          
          /***************************\
          | Handle "END" Detection    |
          | Might be "END IF" might   |
          |       be just "END"       |
          \***************************/
    
       if (!strncmp(token,"END",3)) {
	  
	  if (strstr(gunk,"IF")) {
	     if_info.count--;

	     
	     if (if_info.head[if_info.count].else_line!=-1) {
                add_link(&link_info,if_info.head[if_info.count].else_line,0,
			       line_number+1,0,NULL,"ELSE -> ENDIF");
	     }
	     else {
		add_link(&link_info,if_info.head[if_info.count].if_line,0,
			 line_number+1,0,"ELSE","ELSE -> ENDIF");
	     }
	     
	     previous_block=end_block(&current_block,fout);     
	     
	     
		
	     
	     add_link(&link_info,previous_block,0,line_number+1,0,NULL,"END IF PT");	
             pop_if(&if_info);
	     
	     if (if_info.else_ifs) {
		
	        for(i=0;i<if_info.else_ifs;i++) {	
		   add_link(&link_info,if_info.head[if_info.count-(i+1)].else_line,0,
	 		 line_number+1,0,NULL,"ELSE -> ENDIF");
	           pop_if(&if_info);	
				   
		}
		if_info.else_ifs=0;
	     }
 
		
		
	     current_label=LABEL_START_NEW_NO_FALLTHROUGH;
	     
	     DEBUG(stdout,"POP IF from %i\n",line_number);
	     
	  }
	  else {
	        /************\
	        | REAL END   |
	        \************/

	     if ((current_label>0) && (current_label!=line_number)) {
	        add_link(&link_info,current_label,0,line_number,0,NULL,NULL);
                end_block(&current_block,fout);
	     }
	     			
	     fprintf(fout,"\t%i [label=\"END\" shape=tripleoctagon color=red];\n",
		          line_number);
	     current_label=LABEL_BLOCK_ENDED;
	     early_end=1;
	  }
	   
       }
    
          /*********\
          | ELSE    |
          \*********/
       if (!strncmp(token,"ELSE",sizeof(token))) {
	    
	     /* We are the special "ELSE IF" case */
	     /* This case is *pure* evil */
	  if (strstr(gunk,"IF")) {

	     if_info.head[if_info.count-1].else_line=current_label;
	     previous_block=end_block(&current_block,fout);
	     add_link(&link_info,if_info.head[if_info.count-1].if_line,0,
		      line_number,0,"ELSE",NULL);  	       
	     
	     start_block(&current_block,line_number);
	     current_label=line_number;
	     add_block_line(&current_block,line_number,gunk);
	     previous_block=end_block(&current_block,fout);
	     
	     add_link(&link_info,previous_block,0,line_number+1,0,
			      "THEN",NULL);
	     
	       DEBUG(stderr,"EVIL PUSH %i\n",line_number+1);
	       push_if(&if_info,current_label,line_number+1,1);
	       current_label=LABEL_START_NEW_NO_FALLTHROUGH;	     
	  }
	     /* Normal ELSE */
	  else {
	     add_link(&link_info,if_info.head[if_info.count-1].if_line,0,
		      line_number+1,0,"ELSE",NULL);
	  
	     previous_block=end_block(&current_block,fout);
	     if_info.head[if_info.count-1].else_line=current_label;
	     current_label=LABEL_START_NEW_NO_FALLTHROUGH;
	  }
       }
       
          /***********************************************\
	  | Handle IF token                               |
	  |                                               |
          | We have 3 kinds we care about                 |
          |   Arithmatic:  IF (SOMETHING) X,Y,Z           |
          |   Logical:     IF (SOMETHING) xxxx            |
          |   Block:       IF (S) THEN ... ELSE ... ENDIF |
          \***********************************************/

       if (!strncmp(token,"IF",2)) {

	 i=find_end_of_parenthesis(temp_string); 	 
	 strncpy(if_gunk,temp_string+i,BUFSIZ);
	 
	 temp_string[i]='\0';
	 pointer=strstr(temp_string,"IF");

	  
	 if (sscanf(if_gunk,"%i",&if_neg)!=1) {
	  
            get_token(point_to_non_whitespace(if_gunk),if_token,BUFSIZ);
	    

	       /************************\
	       | BLOCK IF               |
	       | aka IF (s) THEN case   |
	       \************************/
	    if (!strncmp(if_token,"THEN",4)) {
	       add_block_line(&current_block,line_number,gunk);
	     
	       previous_block=end_block(&current_block,fout);
	       
	       add_link(&link_info,previous_block,0,line_number+1,0,
			      "THEN",NULL);
	       	       
	       push_if(&if_info,current_label,-1,0);
	       current_label=LABEL_START_NEW_NO_FALLTHROUGH;
	    }
	       /***********************\
	       | LOGICAL IF            |
	       | aka IF (s) xxxx case  |
	       \***********************/
	    
	       
             else {
	           /* Handle special cases */
		   /* Luckily DO, non-arithmatic IF, and others forbidden */
		
	        if ( (!strncmp(if_token,"GO",strlen(if_token)))
	           ||
	           (!strncmp(if_token,"GOTO",strlen(if_token))) ) {
		   
		   add_block_line(&current_block,line_number,gunk);
                      /* Handle the GOTO */
	           handle_goto(fout,&current_block,&link_info,if_gunk,
			       &current_label,1);
	              /* Handle the "ELSE" case */
	           previous_block=end_block(&current_block,fout);
	           add_link(&link_info,previous_block,0,
			    line_number+1,0,"ELSE",NULL);
	           current_label=LABEL_START_NEW_NO_FALLTHROUGH;       
		}
		else if (!strncmp(if_token,"IF",strlen(if_token))) {
		   fprintf(stderr,"!!ERROR!! Don't handle Logical IF -> Arithmatic IF yet\n\n");
		   exit(0);
		}
		else {      
	           sprintf(local_string,"%s\\n%s",gunk,if_gunk);   
	           add_block_line(&current_block,line_number,local_string);
		}
	    }
	    
	    
	    
	 }
	     /*****************\
	     | ARITHMATIC IF   |
	     \*****************/
	 else {
	 
	       /* Separate the goto targets */
	    for(i=0;i<strlen(if_gunk);i++) {
	       if (if_gunk[i]==',') if_gunk[i]=' ';
	    }
	       /* read in the goto targets */
	    sscanf(if_gunk,"%i %i %i",&if_neg,&if_zero,&if_pos);
	    add_block_line(&current_block,line_number,pointer);
	    add_link(&link_info,current_label,0,
			   line_from_label(if_neg),0,"< 0",NULL);
	    add_link(&link_info,current_label,0,
			   line_from_label(if_zero),0,"= 0",NULL);
	    add_link(&link_info,current_label,0,
			   line_from_label(if_pos),0,"> 0",NULL);
	    
	    DEBUG(stderr,"%i: IF %i,%i,%i\n",current_label,if_neg,if_zero,if_pos);
            previous_block=end_block(&current_block,fout);
	    current_label=LABEL_BLOCK_ENDED;	 
	 }
	 
      }
   
       
          /********************\
	  | RETURN token       |
	  \********************/
       if (!strncmp(token,"RETURN",6) ) {

	  if (current_label!=line_number) {
	     add_link(&link_info,current_label,0,line_number,0,NULL,NULL);
	     end_block(&current_block,fout);
	  }
	  
	   fprintf(fout,"\t%i [label=\"%i\\nRETURN\" "
		        "shape=triangle color=darkgreen];\n",
		        line_number,label_from_line(current_label));
	   current_label=LABEL_BLOCK_ENDED;
       }

          /********************\
	  | READ token         |
	  \********************/
       if ( (!strncmp(token,"READ",4) ) && print_reads) {
	  add_block_line(&current_block,line_number,gunk);
	  
	  i=find_end_of_parenthesis(gunk);
	  gunk[i]='\0';
	  
	     /* Handle case of "END=XXX" */
	  if (strstr(gunk,"END")) {
	     for(i=0;i<strlen(gunk);i++) {  
	        switch(gunk[i]) {	
		 case ',': case '=': case ')': gunk[i]=' ';
		}
	     }
	     sscanf(strstr(gunk,"END")+4,"%i",&temp_label);
	     add_link(&link_info,current_label,line_number,
			    line_from_label(temp_label),0,"IF END",NULL);
	  }
	  
       }
       
          /********************\
	  | WRITE token         |
	  \********************/
       if ( (!strncmp(token,"WRITE",5) ) && print_writes) {
	  add_block_line(&current_block,line_number,gunk);
	  	  
       }
       
          /********************\
	  | PROGRAM token      |
	  \********************/
       if ( (!strncmp(token,"PROGRAM",7))) {
	  add_block_line(&current_block,line_number,gunk);
       }
       
          /*********************\
	  | SUBROUTINE token    |
	  \*********************/
       if ( (!strncmp(token,"SUBROUTINE",10))) {
	  add_block_line(&current_block,line_number,gunk);
       }
       
          /*********************\
	  | CALL token          |
	  \*********************/
       if (!strncmp(token,"CALL",4) ) {
	  temp_pointer=strstr(gunk,"CALL");
	  DEBUG(stderr,"CALL : %s\n",temp_pointer);
	  add_block_line(&current_block,line_number,temp_pointer);
			 
       }
	 
          /******************\
	  | STOP token       |
	  \******************/
       if (!strncmp(token,"STOP",4) ) {  

	  if (current_label!=line_number) {
	     add_link(&link_info,current_label,0,line_number,0,NULL,NULL);
	     end_block(&current_block,fout);
	  }
	  for(i=0;i<strlen(gunk);i++) {
	     if (gunk[i]=='"') gunk[i]=' ';
	  }
	  
	  fprintf(fout,"\t%i [label=\"%i\\nSTOP\\n%s\" shape=octagon color=red];\n",
		  line_number,label_from_line(line_number),gunk+5);
	  current_label=LABEL_BLOCK_ENDED;
       }
       
          /************************\
	  | GOTO token             |
	  |                        |
	  | We have two kinds...   |
	  |    GOTO label          |
	  |    GOTO (x,y,z),k      |
	  \************************/
       if ( (!strncmp(token,"GO",sizeof(token)))
	    ||
	    (!strncmp(token,"GOTO",4) ) ) {
	 
            handle_goto(fout,&current_block,&link_info,gunk,&current_label,0);
	    end_block(&current_block,fout);
	    current_label=LABEL_BLOCK_ENDED;
      }
   }
   
   fprintf(fout,"\n\t // LINKS\n");
   dump_links(&link_info,fout);
   free_links(&link_info);
   
   fprintf(fout,"}\n");
   
   done_and_close:
   if (fin!=NULL) fclose(fin);
   if (fout!=NULL) fclose(fout);
   return 0;
}
